s         n     j&                                              tsxp        Thurlby-Thandar TSXP series PSU.              $    Thurlby-Thandar TSX----P series power supplies

This instrument module provides GPIB support for
the TSX----P series power supplies. Instruments in
this range meet the requirements of IEEE 488.2
standard. The module will be updated from time to
time as new instruments become available in the
range.

Instruments supported are:

TSX3510P         35 volt, 10 amp

The module contains the following functions:

1. Initialise.

2. Configuration
        1. Set Output
        2. Master Output control
        3. Status Reporting

3. Measurement and Status.
        1. Read Output
        2. Read Status

4. Local Storage
        1. Store
        2. recall

5. Miscellaneous
        1. Send Command String
        2. Get Response String
        3. Send Block From File
        4. Get Block To File

6. Close    n                  Configuration Functions

These functions perform the complete set up of the
TSX----P power supply. The parameters are sent to
the instrument but the status is not checked so no
instrument errors will be reported. Status may be
read at any time with the read status function.
Available functions are listed below.

Set output: Set voltage, current, OVP, output
status and readback meter damping for each output.

Output Switch control: Set master output switch on
or off.

Status reporting: Specify the way in which status
is reported and Service Request is generated as
defined in the IEEE 488.2 standard.
    B                Measurement and Status

These functions allow the voltage and current to
be read on each output and the status registers to
be interrogated. Available functions are as
follows.

Read output: Reads the current and voltage from
the output.

Read status: Returns the byte value in the
selected status register.
                      Local Storage

These functions allow the instrument set up to be
stored or recalled from local non-volatile memory.

Store saves the set up to a store specified by the
user.

Recall gets a set up from a store specified by the
user and install it in the TSX----P.
    -                 Miscelaneous

These functions allow commands to be sent and
responses to be received which are not covered by
other panels in the instrument driver.

Any commands may be sent as a string of bytes.

Responses are received as a string of bytes for
later interrogation by the user program.    D    Panel name:     Initialise

Description:

 Initialises the TSX----P in the following way

        - opens the instrument and sets the GPIB
        address to the specified value.

        - sends device clear and clear status
        commands.

        - queries the instrument to determine the
        type/model number.
    V    Control name:   GPIB Address

Description:    This control specifies the
                address used to communicate with
                the TSX----P power supply. It must
                correspond with the value set up
                at the instrument front panel.

Variable type:  Integer

Valid range:    0 to 30

Default value:  11

    
     Control Name:  Instrument ID

 Description:   Returns an Instrument ID that is
                used in all subsequent function
                calls to select the instrument at
                the Address specified.

                If more than one instrument of the
                same type is used, this value will
                be used to differentiate between
                them. The first instrument
                initialized will be assigned an
                Instrument ID of 1.

 Variable Type: Integer        Control nams:   Error

Variable Type: Integer

Description:

 This returned value is placed in the global
 variable tsxp_err. The value zero indicates
 complete success.

    Error              Description
 ------------------------------------------------
       0     Success

      -1     GPIB Address out of range

     220     Unable to open instrument
     223     Device at specified address is not
             a TSX----P
     230     GPIB write error
     231     No response from instrument
     233     Unable to configure GPIB address
     300     Unable to configure board/device
             when attempting to set timeout to
             30sec or end message to on.
     =            GPIB Address                      j =          Instrument ID                     |          Error                           "                                          2 8                                            11    	            	            (Instrument driver version 2.0 Apr. 1995    Copyright (c) TTi Ltd.   X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.                 Instrument ID                      1       Panel name:     Set Output

Description:

 Set voltage, current, OVP, output status and
 readback meter damping. The values which are
 legal depend on the instrument type.

 The primary function sets the voltage and
 current.

 The secondary function set_ovp sets the over
 voltage limit on the output.

 The secondary function, set damping, specifies
 the current meter damping to be on or off.
         Control name:   Voltage

Description:    The voltage value to which the
                output will be set. The
                value is expressed in Volts.

Variable type:  real

Valid range:    instrument dependent

         Control name:   Current

Description:    The current limit value to which
                the output will be set.
                The value is expressed in Amps.

Variable type:  real

Valid range:    instrument dependent


        Control name:   Error

Variable Type: Integer

Description:

 This returned value is placed in the global
 variable tsxp_err. The value zero indicates
 complete success.


    Error              Description
 ------------------------------------------------
        0   Success

       -1   instrument ID out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out                Voltage                             s         Current                            p t         Error                                      	                Control name:   OVP

Description:    The over voltage protection value.
                The value is expressed in
                Volts.

Variable type:  real

Valid range:    instrument dependent


                OVP                                       Control name:   Meter Damping

Description:    Specifies the dampimg applied to
                the readback current metering of
                the output.

Variable type:  integer

Valid range:    On = 0 , Off = any non-zero
                value

default value:  Off

                 Meter Damping                      On 1 Off 0    Q    Panel name:     Output Switch

Description:

 Set the output switch on or off.
         Control name:   Output Switch

Description:    Used to set the output
                switch On or Off.

Variable type:  integer

Valid range:    Off = 0 , On = any non-zero value

default value:  Off
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.        Control name:   Error

Variable type:  Integer.

Description:

 This returned value is placed in the global
 variable tsxp_err. The value zero indicates
 complete success.


    Error              Description
 ------------------------------------------------
        0     Success

       -1   instrument ID out of range
       -2   Output Switch value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out



     M           Output Switch                                  Instrument ID                                Error                              On 1 Off 0    1    	           -    Panel name:     Status Reporting

Description:

 Specify the way in which status is reported and
 Service Request is generated as defined in the
 IEEE 488.2 standard.

 The function provides access to the four status
 enable registers in the TSX----P power supply,
 these are:

 Service Request Enable Register

        - Specifies which bits, when set, in the
        Status Byte register will generate a
        Service Request.

 Standard Event Enable Register

        - Specifies which bits, when set, in the
        Standard Event Status register will set
        the ESB bit in the Status Byte Register.

 Limit Event Register

        - Specifies which bits, when set, in the
        Limit Event Status register will set the
        LIM bit in the Status Byte Register.

 Parallel Poll Enable Register

        - Specifies which bits, when set, in the
        Status Byte register will be used to form
        the ist local message

 See the IEEE 488.2 Standard and the instrument
 instruction book for a full description of status
 reporting capabilities.


         Control name:   Set Status Enable

Description:    Used to select which enable
                register will receive the byte
                value.

Variable type:  integer

Valid range:    min = 0 , max = 3

Default value   0 (SRQ Enable)

         Control name:   Value

Description:    A byte value which will be written
                to the selected enable register.

Variable type:  integer

Valid range:    0 to 255

Default value:  0
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.        Control name:   Error

Variable type:  Integer.

Description:

 This returned value is placed in the global
 variable tsxp_err. The value zero indicates
 complete success.

    Error              Description
 ------------------------------------------------
       0     Success

      -1   instrument ID out of range
      -2     Control value out of range
      -3     Byte value out of range

     230     GPIB write error
     231     No response from instrument
     232     Device not initialised

    ' ]           Set Status Enable                 ( ]          Value                             )             Instrument ID                     +          Error                                         :SRQ enable 0 Event Enable 1 Limit Enable 2 Parallel Pol 3    0    1    	           X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    //             Instrument ID                      1       Panel name:     Read Output

Description:

 Returns the output voltage and/or current.

 Both functions are secondary so that either one
 or both mat be used.

 The secondary function read_volts returns the
 output voltage.

 The secondary function read_current returns the
 current being drawn from the output.

NOTE: Errors are returned in the tsxp_err variable

Variable type:  Integer.

This value is placed in the global
variable tsxp_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success

      -1   instrument ID out of range

     230     GPIB write error
     231     No response from instrument
     232     Device not initialised
         Control Name:   Output current

Description:    Current being output by the power
                supply.

Control Type:   Real    4            Output Current                     	                    Output Voltage                     	           x    Panel name:     Read Status

Description:    Returns the byte value from the
                selected status register.         Control name:   Read Status

Description:    Used to select which status
                register to read

Variable type:  integer

Valid range:    min = 0 , max = 6

Default value   0 (Status Byte)

         Control Name:   Value

Description:    Retuened byte value of the
                selected register.

Control Type:   integer

Valid range:    0 to 255 - register value
                -1 - an error was encountered.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.                           Error

Variable type:  Integer.

This returned value is placed in the global
variable tsxp_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     instrument ID out of range
      -2     Status register identifier out of
             range

     230     GPIB write error
     231     No response from instrument
     232     Device not initialised
    6E =           Read Status                       7 =+          Value                             7             Instrument ID                     :X          Error                                         bStatus byte 0 Std Event 1 Limit Event 2 SRQ enable 3 Event Enable 4 Limit Enable 5 Parallel Pol 6    	            1    	                Panel name:     Store

Description:    Saves the complete state of the
                TSX----P to local non-volatile
                memory.         Control name:   Store number

Description:    Select the number of the store to
                receive the instrument set up.

Variable type:  integer

Valid range:    1 to 25
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    z                       Error

Variable type:  Integer.

This returned value is placed in the global
variable tsxp_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     instrument ID out of range
      -2     Store number out of range

     230     GPIB write error
    >; ]           Store number                      >             Instrument ID                     AV          Error                                  1    	            w    Panel name:     Recall

Description:    Recalls an instrument set up from
                a previous store operation.         Control name:   Store number

Description:    Select the number of the store
                from which to recall the
                instrument set up.

Variable type:  integer

Valid range:    1 to 25
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    z                       Error

Variable type:  Integer.

This returned value is placed in the global
variable tsxp_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     instrument ID out of range
      -2     Store number out of range

     230     GPIB write error
    D ]           Store number                      D             Instrument ID                     G@          Error                                  1    	                Panel name:     Send command string

Description:    Sends a string of bytes to the
                TSX----P from a string variable.         Control name:   Command String

Description:    This control specifies data to be
                sent to the TSX----P. The absolute
                maximum length allowed is 2000
                bytes.

Variable type:  String


    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    x                       Error

Variable type:  Integer.

This returned value is placed in the global
variable tsxp_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success

      -1     instrument ID out of range

     230     GPIB write error
     232     Device not initialised
    J =          Command String                    J             Instrument ID                     MS          Error                              "*RST"    1    	                Panel name:     Get response string

Description:    Reads a response from the TSX----P
                into a string variable.        Control name:   Response Stirng

Description:    This control specifies a string
                variable to receive the response
                from the TSX----P. The string must
                be long enough to receive the
                response to avoid overflow. To aid
                in checking this the number of
                bytes put into the string is
                returned from the function. The
                absolute maximum length allowed is
                2000 bytes.

Variable type:  String
         Control name:   Number of Bytes

Description:    This value is the number of bytes
                returned by the TSX----P and
                placed in the string.

Variable type:  Integer    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.                           Error

Variable type:  Integer.

This returned value is placed in the global
variable tsxp_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success

      -1     instrument ID out of range

     231     No response from instrument
     232     Device not initialised
    P =          Response String                   R) =9          Number of Bytes                   R             Instrument ID                     UQ          Error                              	            	            1    	                Panel name:     Send block from file

Description:    Sends a binary block to the
                TSX----P from a disc file.

Note            This operation is usefull for
                Learn and Store blocks.         Control name:   File name

Description:    This control specifies file name
                from which the binary block will
                be sent to the TSX----P.

Variable type:  String - max length 50 characters


    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.                           Error

Variable type:  Integer.

This returned value is placed in the global
variable tsxp_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success

      -1     instrument ID out of range

     300     Refer to ibsta and iberr as specified
             for the GPIB library function ibwrtf
    X M          File name                         Y             Instrument ID                     [          Error                                  1    	                Panel name:     Get block to file

Description:    Gets a binary block from the
                TSX----P and writes it to a disc
                file.

Note            This operation is usefull for
                Learn and Store blocks.         Control name:   File name

Description:    This control specifies file name
                to which the binary block will be
                written when read from the
                TSX----P.

Variable type:  String - max length 50 characters


    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.                           Error

Variable type:  Integer.

This returned value is placed in the global
variable tsxp_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success

      -1     instrument ID out of range

     300     Refer to ibsta and iberr as specified
             for the GPIB library function ibrdf
    _I M          File name                         `K             Instrument ID                     b          Error                                  1    	                Panel name:     Close

Description:    Takes the instrument off-line.
                The  instrument must  be
                reinitialized to use it again.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.                           Error

This returned value is placed in the global
variable tsxp_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success

      -1     instrument ID out of range

     221     Unable to close device
     230     GPIB write error
     232     Device not initialised

Variable type:  Integer.    e             Instrument ID                     h          Error                              1    	                  	  .     K.    init                                       t  8                                       4  O    N       set_op                               M J {   set_ovp                           %    C z   set_damping                              h  "     K.    op_switch                                #  -     K.    set_status                               1   # 8                                       1  5C     H {   read_current                      5    \  H {    read_volts                               5  <B     K.    read_status                              =  B     K.    store                                    C  H     K.    recall                                   Iv  N     K.    send_cmd                                 O  V     K.    get_response                             W  ]     K.    send_from_file                           ^R  dM     K.    get_to_file                              e  i     K.    close                                                                       DInitialise                          Configure                            Set Output                           DOutput Switch                        DStatus Reporting                    "Measurement and Status               Read Output                          DRead Status                         lLocal Storage                        DStore                                DRecall                              Miscellaneous                        DSend Command String                  DGet Response String                  DSend Block From File                 DGet Block to File                    DClose                           